{\rtf1\ansi\ansicpg1252\cocoartf2821
\cocoatextscaling0\cocoaplatform0{\fonttbl\f0\fswiss\fcharset0 Helvetica;}
{\colortbl;\red255\green255\blue255;}
{\*\expandedcolortbl;;}
\paperw11900\paperh16840\margl1440\margr1440\vieww11520\viewh8400\viewkind0
\pard\tx720\tx1440\tx2160\tx2880\tx3600\tx4320\tx5040\tx5760\tx6480\tx7200\tx7920\tx8640\pardirnatural\partightenfactor0

\f0\fs24 \cf0 <?php\
/*\
Plugin Name: Woo Pastilles par Attributs\
Description: Affiche des pastilles sur les images produits selon leurs attributs. Configuration via R\'e9glages > Pastilles Produits.\
Version: 1.0\
Author: Gemini\
*/\
\
if ( ! defined( 'ABSPATH' ) ) exit;\
\
// 1. CR\'c9ATION DU MENU D'ADMINISTRATION\
add_action('admin_menu', 'wpp_add_admin_menu');\
function wpp_add_admin_menu() \{\
    add_options_page(\
        'Pastilles Produits', \
        'Pastilles Produits', \
        'manage_options', \
        'woo-pastilles', \
        'wpp_options_page'\
    );\
\}\
\
// 2. ENREGISTREMENT DES R\'c9GLAGES\
add_action('admin_init', 'wpp_settings_init');\
function wpp_settings_init() \{\
    register_setting('wppPlugin', 'wpp_settings');\
\}\
\
// 3. CHARGEMENT DES SCRIPTS ADMIN (POUR L'UPLOADER D'IMAGE)\
add_action('admin_enqueue_scripts', 'wpp_admin_scripts');\
function wpp_admin_scripts($hook) \{\
    if ($hook != 'settings_page_woo-pastilles') return;\
    wp_enqueue_media();\
\}\
\
// 4. PAGE D'ADMINISTRATION (HTML + JS)\
function wpp_options_page() \{\
    ?>\
    <div class="wrap">\
        <h1>Configuration des Pastilles Produits</h1>\
        <form action="options.php" method="post">\
            <?php\
            settings_fields('wppPlugin');\
            do_settings_sections('wppPlugin');\
            $options = get_option('wpp_settings', []);\
            ?>\
            \
            <style>\
                .wpp-row \{ display: flex; gap: 10px; margin-bottom: 10px; align-items: center; background: #fff; padding: 10px; border: 1px solid #ddd; \}\
                .wpp-preview \{ max-width: 40px; max-height: 40px; display: block; margin-left: 10px; \}\
            </style>\
\
            <div id="wpp-container">\
                <p>Associez le <strong>nom de l'attribut</strong> (ex: Bio, Vegan, Promo) \'e0 une image.</p>\
                <?php \
                if (!empty($options)) \{\
                    foreach ($options as $index => $item) \{\
                        wpp_render_row($index, $item['name'], $item['image']);\
                    \}\
                \} else \{\
                    wpp_render_row(0, '', '');\
                \}\
                ?>\
            </div>\
\
            <button type="button" class="button" id="wpp-add-row">Ajouter une ligne</button>\
            <br><br>\
            <?php submit_button(); ?>\
        </form>\
    </div>\
\
    <script>\
    jQuery(document).ready(function($)\{\
        var count = <?php echo !empty($options) ? count($options) : 1; ?>;\
\
        // Ajouter une ligne\
        $('#wpp-add-row').click(function()\{\
            var row = `<?php wpp_render_js_row(); ?>`.replace(/INDEX/g, count);\
            $('#wpp-container').append(row);\
            count++;\
        \});\
\
        // Supprimer une ligne\
        $(document).on('click', '.wpp-remove', function()\{\
            $(this).closest('.wpp-row').remove();\
        \});\
\
        // Upload Image\
        $(document).on('click', '.wpp-upload', function(e)\{\
            e.preventDefault();\
            var button = $(this);\
            var custom_uploader = wp.media(\{\
                title: 'Choisir une pastille',\
                button: \{ text: 'Utiliser cette image' \},\
                multiple: false\
            \}).on('select', function() \{\
                var attachment = custom_uploader.state().get('selection').first().toJSON();\
                button.prev('input').val(attachment.url);\
                button.parent().find('.wpp-preview').attr('src', attachment.url).show();\
            \}).open();\
        \});\
    \});\
    </script>\
    <?php\
\}\
\
// Helper pour afficher une ligne (PHP)\
function wpp_render_row($index, $name, $image) \{\
    echo '<div class="wpp-row">';\
    echo '<input type="text" name="wpp_settings['.$index.'][name]" placeholder="Nom de l\\'attribut (ex: Bio)" value="'.esc_attr($name).'" size="30" />';\
    echo '<input type="text" name="wpp_settings['.$index.'][image]" placeholder="URL de l\\'image" value="'.esc_attr($image).'" class="wpp-url" size="50" />';\
    echo '<button type="button" class="button wpp-upload">Choisir Image</button>';\
    echo '<img src="'.esc_attr($image).'" class="wpp-preview" style="'.($image ? '' : 'display:none;').'" />';\
    echo '<button type="button" class="button wpp-remove">X</button>';\
    echo '</div>';\
\}\
\
// Helper pour le template JS\
function wpp_render_js_row() \{\
    $html = '<div class="wpp-row">';\
    $html .= '<input type="text" name="wpp_settings[INDEX][name]" placeholder="Nom de l\\'attribut (ex: Bio)" size="30" />';\
    $html .= '<input type="text" name="wpp_settings[INDEX][image]" placeholder="URL de l\\'image" class="wpp-url" size="50" />';\
    $html .= '<button type="button" class="button wpp-upload">Choisir Image</button>';\
    $html .= '<img src="" class="wpp-preview" style="display:none;" />';\
    $html .= '<button type="button" class="button wpp-remove">X</button>';\
    $html .= '</div>';\
    echo $html; // Pas d'\'e9chappement ici car inject\'e9 dans JS\
\}\
\
// 5. AFFICHAGE FRONTEND (SUR LES PRODUITS)\
add_action( 'woocommerce_before_shop_loop_item_title', 'wpp_display_badges', 10 );\
function wpp_display_badges() \{\
    global $product;\
    $options = get_option('wpp_settings', []);\
    if (empty($options)) return;\
\
    // Cr\'e9er un tableau simple Nom => Image pour faciliter la recherche\
    $badges_map = [];\
    foreach ($options as $opt) \{\
        if (!empty($opt['name']) && !empty($opt['image'])) \{\
            $badges_map[strtolower(trim($opt['name']))] = $opt['image'];\
        \}\
    \}\
\
    $attributes = $product->get_attributes();\
    $found_badges = [];\
\
    foreach ( $attributes as $attribute ) \{\
        if ( $attribute->is_taxonomy() ) \{\
            $terms = wp_get_post_terms( $product->get_id(), $attribute->get_name(), 'all' );\
            foreach ( $terms as $term ) \{\
                $term_name = strtolower(trim($term->name));\
                if ( isset($badges_map[$term_name]) ) \{\
                    $found_badges[] = $badges_map[$term_name];\
                \}\
            \}\
        \} else \{\
            $options_text = $attribute->get_options();\
            foreach ( $options_text as $option ) \{\
                $opt_name = strtolower(trim($option));\
                if ( isset($badges_map[$opt_name]) ) \{\
                    $found_badges[] = $badges_map[$opt_name];\
                \}\
            \}\
        \}\
    \}\
\
    if (!empty($found_badges)) \{\
        echo '<div class="wpp-badge-container">';\
        foreach ($found_badges as $img_url) \{\
            echo '<img src="' . esc_url($img_url) . '" class="wpp-badge-img" />';\
        \}\
        echo '</div>';\
    \}\
\}\
\
// 6. CSS FRONTEND\
add_action('wp_head', 'wpp_frontend_css');\
function wpp_frontend_css() \{\
    ?>\
    <style>\
        .woocommerce ul.products li.product .woocommerce-loop-product__link, \
        .woocommerce-loop-product__link \{\
            position: relative !important;\
        \}\
        .wpp-badge-container \{\
            position: absolute;\
            top: 10px;\
            left: 10px;\
            z-index: 20;\
            display: flex;\
            flex-direction: column;\
            gap: 5px;\
            pointer-events: none;\
        \}\
        .wpp-badge-img \{\
            width: 45px;\
            height: auto;\
            box-shadow: 0 2px 4px rgba(0,0,0,0.15);\
            border-radius: 50%;\
            transition: transform 0.2s;\
        \}\
        .wpp-badge-img:hover \{ transform: scale(1.1); \}\
    </style>\
    <?php\
\}}